package com.agilex.healthcare.veteranappointment.domain;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.agilex.healthcare.mobilehealthplatform.domain.DomainTransferObject;
import com.agilex.healthcare.veteranappointment.datalayer.appointment.CCAppointmentRequestPo;
import gov.va.vamf.scheduling.communitycare.domain.FormAddress;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlAccessorType(value = XmlAccessType.NONE)
@XmlRootElement(name = "preferredProviders", namespace = Namespace.VeteranAppointmentRequest)
@JsonAutoDetect
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
@JsonIgnoreProperties(ignoreUnknown = true)
public class Provider extends DomainTransferObject {

	@XmlElement
	private String preferredProviderId;

	@XmlElement(nillable = true)
	private String firstName;

	@XmlElement(nillable = true)
	private String lastName;

	@XmlElement(nillable = true)
	private String practiceName;

	@XmlElement(nillable = true)
	private FormAddress address;

	@XmlElement
	private int preferredOrder;

	public Provider() {
		this.address = new FormAddress();
	}

	public String getPreferredProviderId() {
		return preferredProviderId;
	}

	public void setPreferredProviderId(String preferredProviderId) {
		this.preferredProviderId = preferredProviderId;
	}

	public String getFirstName() {
		return firstName;
	}

	public void setFirstName(String firstName) {
		this.firstName = firstName;
	}

	public String getLastName() {
		return lastName;
	}

	public void setLastName(String lastName) {
		this.lastName = lastName;
	}

	public String getPracticeName() {
		return practiceName;
	}

	public void setPracticeName(String practiceName) {
		this.practiceName = practiceName;
	}

	public FormAddress getAddress() {
		return address;
	}

	public void setAddress(FormAddress address) {
		this.address = address;
	}

	public String getProviderStreet() {
		return address.street;
	}

	public void setProviderStreet(String providerStreet) {
		this.address.street = providerStreet;
	}

	public String getProviderCity() {
		return address.city;
	}

	public void setProviderCity(String providerCity) {
		this.address.city = providerCity;
	}

	public String getProviderState() {
		return address.state;
	}

	public void setProviderState(String providerState) {
		this.address.state = providerState;
	}

	public String getProviderZipCode() {
		return address.zipCode;
	}

	public void setProviderZipCode(String providerZipCode) {
		this.address.zipCode = providerZipCode;
	}

	public int getPreferredOrder() {
		return preferredOrder;
	}

	public void setPreferredOrder(int preferredOrder) {
		this.preferredOrder = preferredOrder;
	}
}
